/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.JdkLoggerFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.netty.server.SeleniumHttpInitializer;
import org.openqa.selenium.netty.server.ServerBindException;
import org.openqa.selenium.remote.AddWebDriverSpecHeaders;
import org.openqa.selenium.remote.ErrorFilter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.Message;

public class NettyServer
implements Server<NettyServer> {
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final int port;
    private final String host;
    private final boolean bindHost;
    private final URL externalUrl;
    private final HttpHandler handler;
    private final BiFunction<String, Consumer<Message>, Optional<Consumer<Message>>> websocketHandler;
    private final SslContext sslCtx;
    private final boolean allowCors;
    private Channel channel;

    public NettyServer(BaseServerOptions options, HttpHandler handler) {
        this(options, handler, (str, sink) -> Optional.empty());
    }

    public NettyServer(BaseServerOptions options, HttpHandler handler, BiFunction<String, Consumer<Message>, Optional<Consumer<Message>>> websocketHandler) {
        Require.nonNull("Server options", options);
        Require.nonNull("Handler", handler);
        this.websocketHandler = Require.nonNull("Factory for websocket connections", websocketHandler);
        InternalLoggerFactory.setDefaultFactory(JdkLoggerFactory.INSTANCE);
        boolean secure = options.isSecure();
        if (secure) {
            try {
                this.sslCtx = SslContextBuilder.forServer(options.getCertificate(), options.getPrivateKey()).build();
            }
            catch (SSLException e) {
                throw new UncheckedIOException(new IOException("Certificate problem.", e));
            }
        } else if (options.isSelfSigned()) {
            try {
                SelfSignedCertificate cert = new SelfSignedCertificate();
                this.sslCtx = SslContextBuilder.forServer(cert.certificate(), cert.privateKey()).build();
            }
            catch (CertificateException | SSLException e) {
                throw new UncheckedIOException(new IOException("Self-signed certificate problem.", e));
            }
        } else {
            this.sslCtx = null;
        }
        this.handler = handler.with(new ErrorFilter().andThen(new AddWebDriverSpecHeaders()));
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        this.port = options.getPort();
        this.host = options.getHostname().orElse("0.0.0.0");
        this.bindHost = options.getBindHost();
        this.allowCors = options.getAllowCORS();
        try {
            this.externalUrl = options.getExternalUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException("Server URI is not a valid URL: " + options.getExternalUri(), e);
        }
    }

    @Override
    public boolean isStarted() {
        return this.channel != null;
    }

    @Override
    public URL getUrl() {
        return this.externalUrl;
    }

    @Override
    public void stop() {
        try {
            this.bossGroup.shutdownGracefully().sync();
            this.workerGroup.shutdownGracefully().sync();
            this.channel.closeFuture().sync();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException(new IOException("Shutdown interrupted", e));
        }
        finally {
            this.channel = null;
        }
    }

    @Override
    public NettyServer start() {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler(new LoggingHandler(LogLevel.DEBUG))).childHandler(new SeleniumHttpInitializer(this.sslCtx, this.handler, this.websocketHandler, this.allowCors));
        try {
            this.channel = this.bindHost ? b.bind(new InetSocketAddress(this.host, this.port)).sync().channel() : b.bind(this.port).sync().channel();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException(new IOException("Start up interrupted", e));
        }
        catch (Exception e) {
            if (e instanceof BindException) {
                String errorMessage = String.format("Could not bind to address or port is already in use. Host %s, Port %s", this.host, this.port);
                throw new ServerBindException(errorMessage, (BindException)e);
            }
            throw e;
        }
        return this;
    }
}

