/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.commands;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.TemplateGridServerCommand;
import org.openqa.selenium.grid.commands.DefaultHubConfig;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.distributor.config.DistributorOptions;
import org.openqa.selenium.grid.distributor.local.LocalDistributor;
import org.openqa.selenium.grid.graphql.GraphqlHandler;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.router.ProxyWebsocketsIntoGrid;
import org.openqa.selenium.grid.router.Router;
import org.openqa.selenium.grid.router.httpd.RouterOptions;
import org.openqa.selenium.grid.security.BasicAuthenticationFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.grid.sessionmap.local.LocalSessionMap;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.grid.sessionqueue.local.LocalNewSessionQueue;
import org.openqa.selenium.grid.web.CombinedHandler;
import org.openqa.selenium.grid.web.GridUiRoute;
import org.openqa.selenium.grid.web.RoutableHttpClientFactory;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.Tracer;

@AutoService(value={CliCommand.class})
public class Hub
extends TemplateGridServerCommand {
    private static final Logger LOG = Logger.getLogger(Hub.class.getName());

    @Override
    public String getName() {
        return "hub";
    }

    @Override
    public String getDescription() {
        return "A grid hub, composed of sessions, distributor, and router.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of(StandardGridRoles.DISTRIBUTOR_ROLE, StandardGridRoles.EVENT_BUS_ROLE, StandardGridRoles.HTTPD_ROLE, StandardGridRoles.SESSION_QUEUE_ROLE, StandardGridRoles.ROUTER_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "selenium";
    }

    @Override
    protected Config getDefaultConfig() {
        return new DefaultHubConfig();
    }

    @Override
    protected TemplateGridServerCommand.Handlers createHandlers(Config config) {
        URL externalUrl;
        LoggingOptions loggingOptions = new LoggingOptions(config);
        Tracer tracer = loggingOptions.getTracer();
        EventBusOptions events = new EventBusOptions(config);
        EventBus bus = events.getEventBus();
        CombinedHandler handler = new CombinedHandler();
        LocalSessionMap sessions = new LocalSessionMap(tracer, bus);
        handler.addHandler(sessions);
        BaseServerOptions serverOptions = new BaseServerOptions(config);
        SecretOptions secretOptions = new SecretOptions(config);
        Secret secret = secretOptions.getRegistrationSecret();
        try {
            externalUrl = serverOptions.getExternalUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        NetworkOptions networkOptions = new NetworkOptions(config);
        RoutableHttpClientFactory clientFactory = new RoutableHttpClientFactory(externalUrl, handler, networkOptions.getHttpClientFactory(tracer));
        DistributorOptions distributorOptions = new DistributorOptions(config);
        NewSessionQueueOptions newSessionRequestOptions = new NewSessionQueueOptions(config);
        LocalNewSessionQueue queue = new LocalNewSessionQueue(tracer, distributorOptions.getSlotMatcher(), newSessionRequestOptions.getSessionRequestTimeoutPeriod(), newSessionRequestOptions.getSessionRequestTimeout(), secret, newSessionRequestOptions.getBatchSize());
        handler.addHandler(queue);
        LocalDistributor distributor = new LocalDistributor(tracer, bus, clientFactory, sessions, queue, distributorOptions.getSlotSelector(), secret, distributorOptions.getHealthCheckInterval(), distributorOptions.shouldRejectUnsupportedCaps(), newSessionRequestOptions.getSessionRequestRetryInterval(), distributorOptions.getNewSessionThreadPoolSize(), distributorOptions.getSlotMatcher());
        handler.addHandler(distributor);
        Router router = new Router(tracer, clientFactory, sessions, queue, distributor);
        GraphqlHandler graphqlHandler = new GraphqlHandler(tracer, distributor, queue, serverOptions.getExternalUri(), this.getServerVersion());
        HttpHandler readinessCheck = req -> {
            boolean ready = router.isReady() && bus.isReady();
            return (HttpResponse)new HttpResponse().setStatus(ready ? 200 : 503).setContent((Supplier)Contents.utf8String("Router is " + ready));
        };
        Routable routerWithSpecChecks = router.with(networkOptions.getSpecComplianceChecks());
        String subPath = new RouterOptions(config).subPath();
        GridUiRoute ui = new GridUiRoute(subPath);
        Routable appendRoute = Stream.of(routerWithSpecChecks, Hub.hubRoute(subPath, Route.combine(routerWithSpecChecks, new Routable[0])), Hub.graphqlRoute(subPath, () -> graphqlHandler)).reduce((x$0, xva$1) -> Route.combine(x$0, xva$1)).get();
        if (!subPath.isEmpty()) {
            appendRoute = Route.combine(appendRoute, Hub.baseRoute(subPath, Route.combine(routerWithSpecChecks, new Routable[0])));
        }
        Routable httpHandler = Route.combine(ui, appendRoute);
        UsernameAndPassword uap = secretOptions.getServerAuthentication();
        if (uap != null) {
            LOG.info("Requiring authentication to connect");
            httpHandler = httpHandler.with(new BasicAuthenticationFilter(uap.username(), uap.password()));
        }
        httpHandler = Route.combine(httpHandler, Route.get("/readyz").to(() -> readinessCheck));
        return new TemplateGridServerCommand.Handlers(httpHandler, new ProxyWebsocketsIntoGrid(clientFactory, sessions));
    }

    @Override
    protected void execute(Config config) {
        Require.nonNull("Config", config);
        config.get("server", "max-threads").ifPresent(value -> LOG.log(Level.WARNING, () -> "Support for max-threads flag is deprecated. The intent of the flag is to set the thread pool size in the Distributor. Please use newsession-threadpool-size flag instead."));
        Server server = (Server)this.asServer(config).start();
        LOG.info(String.format("Started Selenium Hub %s: %s", this.getServerVersion(), server.getUrl()));
    }

    private String getServerVersion() {
        BuildInfo info = new BuildInfo();
        return String.format("%s (revision %s)", info.getReleaseLabel(), info.getBuildRevision());
    }
}

