/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.network;

import java.util.Optional;
import org.openqa.selenium.bidi.log.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class Initiator {
    private final Type type;
    private final Optional<Long> columnNumber;
    private final Optional<Long> lineNumber;
    private final Optional<StackTrace> stackTrace;
    private final Optional<String> requestId;

    private Initiator(Type type, Optional<Long> columnNumber, Optional<Long> lineNumber, Optional<StackTrace> stackTrace, Optional<String> requestId) {
        this.type = type;
        this.columnNumber = columnNumber;
        this.lineNumber = lineNumber;
        this.stackTrace = stackTrace;
        this.requestId = requestId;
    }

    public static Initiator fromJson(JsonInput input) {
        Type type = null;
        Optional<Long> columnNumber = Optional.empty();
        Optional<Long> lineNumber = Optional.empty();
        Optional<StackTrace> stackTrace = Optional.empty();
        Optional<String> requestId = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    String initiatorType = (String)input.read((java.lang.reflect.Type)((Object)String.class));
                    type = Type.findByName(initiatorType);
                    continue block14;
                }
                case "columnNumber": {
                    columnNumber = Optional.of((Long)input.read((java.lang.reflect.Type)((Object)Long.class)));
                    continue block14;
                }
                case "lineNumber": {
                    lineNumber = Optional.of((Long)input.read((java.lang.reflect.Type)((Object)Long.class)));
                    continue block14;
                }
                case "stackTrace": {
                    stackTrace = Optional.of((StackTrace)input.read((java.lang.reflect.Type)((Object)StackTrace.class)));
                    continue block14;
                }
                case "requestId": {
                    requestId = Optional.of((String)input.read((java.lang.reflect.Type)((Object)String.class)));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Initiator(type, columnNumber, lineNumber, stackTrace, requestId);
    }

    public Type getType() {
        return this.type;
    }

    public Optional<Long> getColumnNumber() {
        return this.columnNumber;
    }

    public Optional<Long> getLineNumber() {
        return this.lineNumber;
    }

    public Optional<StackTrace> getStackTrace() {
        return this.stackTrace;
    }

    public Optional<String> getRequestId() {
        return this.requestId;
    }

    static enum Type {
        PARSER("parser"),
        SCRIPT("script"),
        PREFLIGHT("preflight"),
        OTHER("other");

        private final String initiatorType;

        private Type(String type) {
            this.initiatorType = type;
        }

        public String toString() {
            return this.initiatorType;
        }

        public static Type findByName(String name) {
            Type result = null;
            for (Type type : Type.values()) {
                if (!type.toString().equalsIgnoreCase(name)) continue;
                result = type;
                break;
            }
            return result;
        }
    }
}

